﻿using System;
using System.Linq;
using VA.TMP.DataModel;
using VA.TMP.Integration.VIMT.HealthShare.StateObject;
using VRM.Integration.Servicebus.Core;

namespace VA.TMP.Integration.VIMT.HealthShare.PipelineSteps.MakeCancelInbound
{
    /// <summary>
    /// Get Service Appointment Step.
    /// </summary>
    public class GetServiceAppointmentStep : FilterBase<MakeCancelInboundStateObject>
    {
        /// <summary>
        /// Execute the step.
        /// </summary>
        /// <param name="state">State object.</param>
        public override void Execute(MakeCancelInboundStateObject state)
        {
            using (var srv = new Xrm(state.OrganizationServiceProxy))
            {
                state.ServiceAppointment = srv.ServiceAppointmentSet.FirstOrDefault(x => x.Id == state.OutboundRequestMessage.ServiceAppointmentId);
                if (state.ServiceAppointment == null) throw new Exception($"Unable to find Service Appointment for: {state.OutboundRequestMessage.ServiceAppointmentId}");
            }
        }
    }
}